<?php
/**
 * Template part for displaying default header layout
 */
$sticky_on = bixol_get_opt( 'sticky_on', false );
$h_introductory = bixol_get_opt( 'h_introductory' );
$top_bar = bixol_get_opt( 'top_bar', 'hide' );

$h_phone_label = bixol_get_opt( 'h_phone_label' );
$h_phone = bixol_get_opt( 'h_phone' );
$h_phone_link = bixol_get_opt( 'h_phone_link' );

$h_email_label = bixol_get_opt( 'h_email_label' );
$h_email = bixol_get_opt( 'h_email' );
$h_email_link = bixol_get_opt( 'h_email_link' );

$h_address_label = bixol_get_opt( 'h_address_label' );
$h_address = bixol_get_opt( 'h_address' );
$h_address_link = bixol_get_opt( 'h_address_link' );

$h_time_label = bixol_get_opt( 'h_time_label' );
$h_time = bixol_get_opt( 'h_time' );

$logo_mobile = bixol_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );

$h_custom_menu_left = bixol_get_page_opt( 'h_custom_menu_left' );
$h_custom_menu_right = bixol_get_page_opt( 'h_custom_menu_right' );
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout2 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?>">

        <?php if($top_bar == 'show') : ?>
            <div id="ct-topbar" class="ct-topbar-layout1">
                <div class="container">
                    <div class="row">
                        <?php if(!empty($h_introductory)) : ?>
                            <div class="ct-topbar-intro">
                                <?php echo ct_print_html($h_introductory); ?>
                            </div>
                        <?php endif; ?>
                        <div class="ct-topbar-social">
                            <?php bixol_social_header(); ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div id="ct-header-middle">
            <div class="container">
                <div class="row">
                    <div class="ct-h-middle-left">
                        <?php if(!empty($h_phone_label) || !empty($h_phone)) : ?>
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-phone"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_phone_label)) : ?>
                                        <label><?php echo esc_attr($h_phone_label).':'; ?></label>
                                    <?php endif; ?>
                                    <?php if(!empty($h_phone)) : ?>
                                        <span><?php echo esc_attr($h_phone); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="tel:<?php echo esc_attr($h_phone_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($h_time_label) || !empty($h_time)) : ?>  
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-alarm-clock"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_time_label)) : ?>
                                        <label><?php echo esc_attr($h_time_label).':'; ?></label>
                                    <?php endif; ?>   
                                    <?php if(!empty($h_time)) : ?>
                                        <span><?php echo esc_attr($h_time); ?></span>
                                    <?php endif; ?>   
                                </div>
                            </div>
                        <?php endif; ?>  
                    </div>
                    <div class="ct-h-middle-right">
                        <?php if(!empty($h_email_label) || !empty($h_email)) : ?>
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-mail"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_email)) : ?>
                                        <label><?php echo esc_attr($h_email); ?></label>
                                    <?php endif; ?>
                                    <?php if(!empty($h_email_label)) : ?>
                                        <span><?php echo esc_attr($h_email_label); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="mailto:<?php echo esc_attr($h_email_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?>
                        <?php if(!empty($h_address_label) || !empty($h_address)) : ?>  
                            <div class="ct-h-middle-item">
                                <div class="ct-h-middle-icon"><i class="flaticon flaticon-pin"></i></div>
                                <div class="ct-h-middle-meta">
                                    <?php if(!empty($h_address_label)) : ?>
                                        <label><?php echo esc_attr($h_address_label); ?></label>
                                    <?php endif; ?>   
                                    <?php if(!empty($h_address)) : ?>
                                        <span><?php echo esc_attr($h_address); ?></span>
                                    <?php endif; ?>   
                                </div>
                                <a href="<?php echo esc_url($h_address_link); ?>" class="ct-h-middle-link"></a>
                            </div>
                        <?php endif; ?>  
                    </div>
                </div>
            </div>
        </div>

        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-navigation ct-header-navigation-left">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ( has_nav_menu( 'menu-left' ) ) {
                                    $attr_menu = array(
                                        'theme_location' => 'menu-left',
                                        'container'  => '',
                                        'menu_id'    => 'ct-main-menu-left',
                                        'menu_class' => 'ct-main-menu clearfix',
                                        'link_before'     => '<span>',
                                        'link_after'      => '</span>',
                                        'walker'         => class_exists( 'EFramework_Mega_Menu_Walker' ) ? new EFramework_Mega_Menu_Walker : '',
                                    );
                                    if(isset($h_custom_menu_left) && !empty($h_custom_menu_left)) {
                                        $attr_menu['menu'] = $h_custom_menu_left;
                                    }
                                    wp_nav_menu( $attr_menu );
                                } ?>
                            </div>
                        </nav>
                    </div>
                    <div class="ct-header-branding">
                        <div class="ct-header-branding-inner">
                            <?php get_template_part( 'template-parts/header-branding' ); ?>
                        </div>
                    </div>
                    <div class="ct-header-navigation ct-header-navigation-right">
                        <nav class="ct-main-navigation">
                            <div class="ct-main-navigation-inner">
                                <?php if ($logo_mobile['url']) { ?>
                                    <div class="ct-logo-mobile">
                                        <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                    </div>
                                <?php } ?>
                                <?php bixol_header_mobile_search(); ?>
                                <?php if ( has_nav_menu( 'menu-left' ) ) {
                                    $attr_menu = array(
                                        'theme_location' => 'menu-left',
                                        'container'  => '',
                                        'menu_id'    => 'ct-main-menu-left-mobile',
                                        'menu_class' => 'ct-main-menu clearfix',
                                        'link_before'     => '<span>',
                                        'link_after'      => '</span>',
                                        'walker'         => class_exists( 'EFramework_Mega_Menu_Walker' ) ? new EFramework_Mega_Menu_Walker : '',
                                    );
                                    if(isset($h_custom_menu_left) && !empty($h_custom_menu_left)) {
                                        $attr_menu['menu'] = $h_custom_menu_left;
                                    }
                                    wp_nav_menu( $attr_menu );
                                } ?>
                                <?php if ( has_nav_menu( 'menu-right' ) ) {
                                    $attr_menu = array(
                                        'theme_location' => 'menu-right',
                                        'container'  => '',
                                        'menu_id'    => 'ct-main-menu-right',
                                        'menu_class' => 'ct-main-menu clearfix',
                                        'link_before'     => '<span>',
                                        'link_after'      => '</span>',
                                        'walker'         => class_exists( 'EFramework_Mega_Menu_Walker' ) ? new EFramework_Mega_Menu_Walker : '',
                                    );
                                    if(isset($h_custom_menu_right) && !empty($h_custom_menu_right)) {
                                        $attr_menu['menu'] = $h_custom_menu_right;
                                    }
                                    wp_nav_menu( $attr_menu );
                                } ?>
                            </div>
                        </nav>
                    </div>
                </div>
            </div>

            <div id="ct-menu-mobile">
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>

    </div>
</header>